#include <bits/stdc++.h>

using namespace std;

#define TRACE(x) cerr << #x << " " << x << endl
#define _ << " " <<

const int MAXN = 500;
const int INF = 1e9;
const int UPPER = 2 * MAXN + 10;

struct Edge {
  int from, to, dist;
  Edge() {}
  Edge(int from, int to, int dist): from(from), to(to), dist(dist) {}
};

bool lt[MAXN];

int n;
int a[MAXN], b[MAXN], dist[UPPER + 10];

bool bellman_ford(int k, vector<Edge> &edges) {
  dist[k + 1] = 0;
  for (int i = 0; i <= k; ++i) dist[i] = INF;
  for (int t = 0; t <= k; ++t) {
    for (auto &e : edges)
      dist[e.to] = min(dist[e.to], dist[e.from] + e.dist);
  }
  for (auto &e : edges)
    if (dist[e.from] + e.dist < dist[e.to])
      return false;
  return true;
}

bool check(int k) {
  vector<Edge> edges;
  for (int i = 0; i <= k; ++i) edges.emplace_back(k + 1, i, 0);
  for (int i = 0; i < n; ++i) {
    for (int j = 0; j + a[i] <= k; ++j) {
      if (lt[i])
        edges.emplace_back(j, j + a[i], b[i]);
      else
        edges.emplace_back(j + a[i], j, -b[i]);
    }
  }
  return bellman_ford(k + 1, edges);
}

int main(void) {
  scanf("%d", &n);
  for (int i = 0; i < n; ++i) {
    char s[4];
    scanf("%d%d%s", &a[i], &b[i], s);
    lt[i] = s[0] == '<';
  }

  int lo = 0, hi = UPPER;
  while (lo < hi) {
    int mid = (lo + hi) / 2 + 1;
    if (check(mid)) lo = mid; else hi = mid - 1;
  }

  if (lo == UPPER) {
    printf("-1\n");
    return 0;
  }

  printf("%d\n", lo);

  assert(check(lo));
  for (int i = 0; i < lo; ++i)
    printf("%d ", dist[i + 1] - dist[i]);
  printf("\n");

  return 0;
}
